#include <iostream>
#include <string>
#include <unordered_set>
using namespace std;

const int MOD = 998244353;

// Funkcija za izracunavanje XOR vrednosti niza
int izracunaj_xor(const string& S) {
    int rezultat = 0;
    for (char c : S) {
        rezultat ^= (c - '0');
    }
    return rezultat;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    string S;
    cin >> S;

    unordered_set<string> posete; // Koristimo set za pracenje razlicitih reci
    posete.insert(S);

    int n = S.size();

    for (int l = 0; l < n; l++) {
        for (int r = l; r < n; r++) {
            // Kopiramo trenutni niz
            string nova_recenica = S;

            // Izracunavamo XOR segmenta [l, r]
            int segment_xor = 0;
            for (int i = l; i <= r; i++) {
                segment_xor ^= (nova_recenica[i] - '0');
            }

            // Zamenjujemo segment sa njegovim XOR rezultatom
            nova_recenica.replace(l, r - l + 1, 1, '0' + segment_xor);

            // Dodajemo novu recenicu u skup
            posete.insert(nova_recenica);
        }
    }

    // Broj razlicitih reci modulo MOD
    cout << posete.size() % MOD << "\n";

    return 0;
}